package coreservlets.filters;

import java.io.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

/** Prosty filtr zapisujcy do pliku dziennika raport
 *  za kadym razem, gdy wywoywany jest powizany z nim
 *  serwlet lub strona JSP.
 *  <P>
 *  Taken from Core Servlets and JavaServer Pages Volume II
 *  from Prentice Hall and Sun Microsystems Press,
 *  http://volume2.coreservlets.com/.
 *  (C) 2007 Marty Hall, Larry Brown, and Yaakov Chaikin;
 *  may be freely used or adapted.
 */
public class LogFilter implements Filter {
  protected FilterConfig config;
  private ServletContext context;
  private String filterName;
  
  public void doFilter(ServletRequest request,
                       ServletResponse response,
                       FilterChain chain)
      throws ServletException, IOException {
    HttpServletRequest req = (HttpServletRequest)request;
    context.log(req.getRemoteHost() +
                " wywoa " +
                req.getRequestURL() +
                " w dniu " + new Date() + ". " +
                "(Raport wygenerowany przez " + filterName + ".)");
    chain.doFilter(request,response);
  }

  public void init(FilterConfig config)
      throws ServletException {
    this.config = config; // na potrzeby klasy podrzdnej.
    context = config.getServletContext();
    filterName = config.getFilterName();
  }
  
  public void destroy() {}
}
